/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class PlanMultiCCD
extends PlanImage {
    PlanImage[] ccd;
    int ref;
    String labelBase;

    protected PlanMultiCCD(Aladin aladin, String label, Vector<Plan> v) {
        super(aladin);
        this.labelBase = label;
        this.setCCD(v);
        this.setRef(0);
    }

    @Override
    protected void setLabel(String label) {
        this.labelBase = label;
    }

    protected void setCCD(Vector<Plan> v) {
        HashSet<String> extName = new HashSet<String>(v.size());
        this.ccd = new PlanImage[v.size()];
        Enumeration<Plan> e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            PlanImage p;
            this.ccd[i] = p = (PlanImage)e.nextElement();
            p.planMultiCCD = this;
            if (extName != null) {
                String a = p.headerFits.getStringFromHeader("EXTNAME");
                if (a == null || extName.contains(a)) {
                    extName = null;
                }
                if (extName != null) {
                    extName.add(a);
                }
            }
            ++i;
        }
        if (extName != null) {
            for (PlanImage p : this.ccd) {
                p.setLabel(this.labelBase + " - " + p.headerFits.getStringFromHeader("EXTNAME"));
            }
        }
    }

    protected Vector<PlanImage> getCCD() {
        Vector<PlanImage> v = new Vector<PlanImage>(this.ccd.length);
        for (PlanImage p : this.ccd) {
            v.add(p);
        }
        return v;
    }

    protected int getSize() {
        return this.ccd.length;
    }

    protected PlanImage getSelectedCCD() {
        return this.ccd[this.ref];
    }

    protected void setRef(int ref) {
        this.ref = ref;
        this.ccd[ref].copy(this, true);
        this.setActivated(true);
        this.selected = true;
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM();
        }
    }

    protected boolean setRef(Coord coo) {
        int i = this.getRef(coo);
        if (i == this.ref || i == -1) {
            return false;
        }
        this.setRef(i);
        return true;
    }

    private int getRef(Coord coo) {
        for (int i = 0; i < this.ccd.length; ++i) {
            if (!this.ccd[i].contains(coo)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void setCM(Object cm) {
        super.setCM(cm);
        this.ccd[this.ref].setCM(cm);
    }

    @Override
    public void setOpacityLevel(float f) {
        super.setOpacityLevel(f);
        for (PlanImage p : this.ccd) {
            p.setOpacityLevel(f);
        }
    }

    @Override
    protected PointD[] getBords(ViewSimple v) {
        PointD[] coins = null;
        for (PlanImage p : this.ccd) {
            PointD[] c = p.getBords(v);
            if (coins == null) {
                coins = c;
                continue;
            }
            if (c[0].x < coins[0].x) {
                coins[0].x = c[0].x;
            }
            if (c[0].y < coins[0].y) {
                coins[0].y = c[0].y;
            }
            if (c[3].x > coins[3].x) {
                coins[3].x = c[3].x;
            }
            if (c[3].y < coins[3].y) {
                coins[3].y = c[3].y;
            }
            if (c[2].x > coins[2].x) {
                coins[2].x = c[2].x;
            }
            if (c[2].y > coins[2].y) {
                coins[2].y = c[2].y;
            }
            if (c[1].x < coins[1].x) {
                coins[1].x = c[1].x;
            }
            if (!(c[1].y > coins[1].y)) continue;
            coins[1].y = c[1].y;
        }
        return coins;
    }

    @Override
    protected void setBufPixels8(byte[] pixels) {
        super.setBufPixels8(pixels);
        this.ccd[this.ref].setBufPixels8(pixels);
    }

    @Override
    protected boolean Free() {
        boolean rep = true;
        for (PlanImage p : this.ccd) {
            rep &= p.Free();
        }
        return rep;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
        for (PlanImage p : this.ccd) {
            p.draw(g, v, dx, dy, op);
        }
    }

    protected static boolean isMultiCCD(Vector<Plan> v) {
        long marge = 0L;
        int order = 10;
        try {
            if (v.size() < 2) {
                return false;
            }
            SMoc moc = null;
            Enumeration<Plan> e = v.elements();
            while (e.hasMoreElements()) {
                Plan p = e.nextElement();
                if (!p.isImage() || !Projection.isOk(p.projd)) {
                    return false;
                }
                if (moc == null) {
                    int w = Math.max(((PlanImage)p).naxis1, ((PlanImage)p).naxis2);
                    double[] res = p.projd.c.GetResol();
                    double size = Math.max(res[0], res[1]) * (double)w;
                    order = Aladin.getAppropriateOrder(size);
                }
                SMoc m = PlanMultiCCD.buildMoc(p.projd, order);
                if (moc == null) {
                    moc = m;
                    marge = (long)((double)moc.getNbValues() * 0.2);
                    continue;
                }
                SMoc inter = moc.intersection(m);
                if (inter.getNbValues() > marge) {
                    return false;
                }
                moc = moc.union(m);
            }
            return true;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static SMoc buildMoc(Projection proj, int order) throws Exception {
        Coord coo = new Coord();
        ArrayList<double[]> cooList = new ArrayList<double[]>(10);
        Dimension dim = proj.c.getImgSize();
        for (int i = 0; i < 4; ++i) {
            coo.x = i == 0 || i == 3 ? 0 : dim.width;
            coo.y = i < 2 ? 0 : dim.height;
            proj.c.GetCoord(coo);
            cooList.add(new double[]{coo.al, coo.del});
        }
        SMoc moc = CDSHealpix.createSMoc(cooList, order);
        return moc;
    }
}

